﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class LabOrder : BasePage
{
    private readonly LabOrderManager _manager;
    private WKF_CASE_ACTIVITY _activity;

    private static IReadOnlyList<string> _navigationSources = new List<string>
    {
        "/LabOrders.aspx",
        "/PatientWorkflows.aspx"
    };

    public LabOrder()
    {
        _manager = new LabOrderManager();

        //Manager Save Notification Event Handler
        _manager.BOSaveSuccess += manager_BOSaveSuccess;

        NavigationSources = _navigationSources;
    }

    protected void Page_Load(object sender, EventArgs e)
    {

        if (!IsPostBack)
        {
            int orderId;
            if (int.TryParse(Request.QueryString["activityId"], out orderId))
            {
                getRefreshLabOrder(orderId);

                ViewState["ReferralCaseId"] = _activity.WKF_CASE.REFERRAL_ID;
                //only for biological
                if (_activity.STD_WKFACTIVITYTYPE_ID == 3)
                    SetupBioLabOrder();
            }

            SetReferringPage();
        }

        RangeValidatorLabRequestDateIsDate.MaximumValue =
        RangeValidatorLabelSampleReceivedDateIsDate.MaximumValue = DateTime.Today.ToShortDateString();
    }

    private void getRefreshLabOrder(int oId)
    {
        _activity = _manager.getLabOrderByOrderID(oId);
        _activity.SetAsChangeTrackingRoot();
    }

    private void SetupBioLabOrder()
    {

        lblSampleType.Text = "URINE";
        lblSampleIDNumber.Text = _activity.WKF_CASE.PATIENT.FullName.Substring(0, 1) + _activity.WKF_CASE.PATIENT.Snum.Substring(_activity.WKF_CASE.PATIENT.Snum.Length - 4, 4);

        if (_activity.LAB_ORDERs.Count > 0)
        {
            LAB_ORDER order = _activity.LAB_ORDERs.First();

            var shortDate = order.LAB_SEND_DATE.HasValue ? order.LAB_SEND_DATE.Value.ToString("yy") : DateTime.Today.ToString("yy");
            lblLabRequestNumber.Text = shortDate + " - " + "TEF" + order.LAB_ORDER_ID.ToString().PadLeft(5, '0');

            if (order.LAB_SEND_DATE.HasValue)
            {
                LabRequestDate.Text = order.LAB_SEND_DATE.Value.ToShortDateString();
            }
            else
            {
                if (_activity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Voided)
                {
                    LabRequestDate.Text = String.Empty;
                }
                else
                {
                    LabRequestDate.Text = DateTime.Now.ToShortDateString();
                }
            }

            if (order.LAB_RECEIVED_DATE.HasValue)
            {
                //txtLabSampleReceivedDate.Text = order.LabReceivedDate.Value.ToShortDateString();
                LabSampleReceivedDate.Text = order.LAB_RECEIVED_DATE.Value.ToShortDateString();
            }
            if (order.LAB_RETURN_DATE.HasValue)
            {
                LabelLabReportDate.Text = order.LAB_RETURN_DATE.Value.ToShortDateString();
            }
            txtBSONumber.Text = order.BSO_NUMBER;
            txtTrackingNumber.Text = order.SHIPMENT_TRACKING_NUMBER;
            txtSampleInstructions.Text = order.SPECIAL_INSTRUCTION;
            txtSampleDescription.Text = order.SAMPLE_DESC;

            SetupAnalytes(order);
        }
        else
        {
            //new lab order doesn't have associated lab order before you save it 1st
            LabRequestDate.Text = DateTime.Today.ToString("d");
        }

        switch (_activity.STD_WKFACTIVITYSTS_ID)
        {
            case (int)WorkflowCaseActivityStatus.New:

                LabelForLabLabelReportDate.Visible = false;
                LabelLabReportDate.Visible = false;
                PrintButton.Enabled = false;
                VoidButton.Enabled = true;
                SaveButton.Enabled = false;
                CompleteButton.Enabled = true;
                LabRequestDate.Enabled = true;
                ReOpenLabOrder.Enabled = false;
                SaveButton.Text = "Save";

                RequiredFieldValidatorLabRequestDate.Enabled = true;

                SaveButton.ValidationGroup = "";

                break;

            case (int)WorkflowCaseActivityStatus.AwaitingResults:

                LabelForLabLabelReportDate.Visible = false;
                LabelLabReportDate.Visible = false;
                PrintButton.Enabled = true;
                VoidButton.Enabled = false;
                SaveButton.Enabled = true;
                CompleteButton.Enabled = false;
                LabRequestDate.Enabled = false;
                RequiredFieldValidatorLabRequestDate.Enabled = true;
                ReOpenLabOrder.Enabled = false;
                CancelButton.Text = "Back";
                SaveButton.ValidationGroup = "LabOrderValidation";
                SaveButton.Text = "Save";
                ReOpenLabOrder.Enabled = false;

                break;

            //case (int)WorkflowCaseActivityStatus.Completed:

            //    PrintButton.Enabled = true;
            //    VoidButton.Enabled = false; 
            //    //SaveButton.Enabled = false;
            //    SaveButton.Enabled = true; 
            //    CompleteButton.Enabled = false; 

            //    break;

            //case (int)WorkflowCaseActivityStatus.InProcess:
            //    CompleteButton.Enabled = true;
            //    PrintButton.Enabled = false;
            //    VoidButton.Enabled = true;
            //    SaveButton.Enabled = true;

            //    break;

            //Closed status
            case (int)WorkflowCaseActivityStatus.Closed:
                LabelForLabLabelReportDate.Visible = true;
                LabelLabReportDate.Visible = true;
                CompleteButton.Enabled = false;
                SaveButton.Enabled = false;
                PrintButton.Enabled = true;
                VoidButton.Enabled = false;
                LabRequestDate.Enabled = false;
                ReOpenLabOrder.Enabled = _manager.CheckWkfCaseStatusForReOpen(_activity.WKF_CASE_ID, WorkFlowActivityTypes.LabResult) ? true : false;
                RequiredFieldValidatorLabRequestDate.Enabled = true;
                CancelButton.Text = "Back";
                SaveButton.ValidationGroup = "";
                SaveButton.Text = "Save";
                break;

            //void status
            case (int)WorkflowCaseActivityStatus.Voided:
                LabelForLabLabelReportDate.Visible = false;
                LabelLabReportDate.Visible = false;
                CompleteButton.Enabled = false;
                SaveButton.Enabled = true;
                PrintButton.Enabled = false;
                VoidButton.Enabled = false;
                LabRequestDate.Enabled = false;
                ReOpenLabOrder.Enabled = false;
                RequiredFieldValidatorLabRequestDate.Enabled = false;
                CancelButton.Text = "Back";
                SaveButton.Text = "Un-Void";
                SaveButton.ValidationGroup = "LabOrderValidation";

                break;
        }
    }

    private void SaveCompleteLabOrder(Func<string> operation)
    {

        LAB_ORDER order;

        if (_activity.LAB_ORDERs.Count > 0)
        {

            order = _activity.LAB_ORDERs.First();

            SaveLabOrder(ref order);

        }
        else
        {
            order = new LAB_ORDER();

            SaveLabOrder(ref order);

            order.WKF_CASE_ACTIVITY_ID = _activity.WKF_CASE_ACTIVITY_ID;
            _activity.LAB_ORDERs.Add(order);
        }
        //set questionnaire in-process status


        OpenCloseReferralAndWorkflowCase(operation);

        _manager.Update(_activity);
        //(this.Master as RegistryMaster).SetDirtyFlag(false);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        FormViewBreadCrumb.DataBind();
        getRefreshLabOrder(_activity.WKF_CASE_ACTIVITY_ID);

    }

    //this is the function that gets all values from page controls to eventually save them in a database  
    private void SaveLabOrder(ref LAB_ORDER labOrder)
    {

        labOrder.LAB_SEND_DATE = Helpers.ConvertStringToNullable<DateTime>(LabRequestDate.Text.Trim());
        //labOrder.LabReceivedDate = Helpers.ConvertStringToNullable<DateTime>(txtLabSampleReceivedDate.Text.Trim());
        labOrder.LAB_RECEIVED_DATE = Helpers.ConvertStringToNullable<DateTime>(LabSampleReceivedDate.Text.Trim());
        labOrder.LAB_RETURN_DATE = Helpers.ConvertStringToNullable<DateTime>(LabelLabReportDate.Text.Trim());

        labOrder.BSO_NUMBER = txtBSONumber.Text.Trim();
        labOrder.SHIPMENT_TRACKING_NUMBER = txtTrackingNumber.Text.Trim();

        labOrder.SPECIAL_INSTRUCTION = txtSampleInstructions.Text.Trim();
        labOrder.SAMPLE_DESC = txtSampleDescription.Text.Trim();
        //EFR registry
        labOrder.STD_REGISTRY_ID = 1;

        SaveAnalytes(labOrder);
    }

    private void SetupAnalytes(LAB_ORDER labOrder)
    {
        List<LAB_ORDER_DETAIL> listDetails = labOrder.LAB_ORDER_DETAILs.ToList();
        var selected = 0;
        foreach (var detail in listDetails)
        {
            int analyteTypeId = detail.STD_ANALYTETYPE_ID;
            //analyte of "other" type 
            if (analyteTypeId == 15)
            {
                OtherAnalyteCheck.Checked = true;
                OtherAnalyteText.Text = detail.OTHER_ANALYTE_NAME;

            }
            else
            {
                ListItem item = AnalytesList.Items.FindByValue(analyteTypeId.ToString());
                if (item != null)
                {
                    //if we find factor nothing else to do here 
                    item.Selected = true;
                    selected++;
                }
            }
        }

        if (selected == 14)
            AnalytesList.Items.FindByValue("0").Selected = true;

    }
    private void SaveAnalytes(LAB_ORDER order)
    {
        var otherValue = 15;
        //add other Analyte
        if (OtherAnalyteCheck.Checked)
        {
            if (!otherValue.In(order.LAB_ORDER_DETAILs.Select(lod => lod.STD_ANALYTETYPE_ID).ToList()))
            {
                LAB_ORDER_DETAIL detail = new LAB_ORDER_DETAIL();


                detail.LAB_ORDER_ID = order.LAB_ORDER_ID;
                detail.STD_ANALYTETYPE_ID = otherValue;
                detail.OTHER_ANALYTE_NAME = OtherAnalyteText.Text.Trim();
                order.LAB_ORDER_DETAILs.Add(detail);

            }

        }
        else
        {
            if (otherValue.In(order.LAB_ORDER_DETAILs.Select(lod => lod.STD_ANALYTETYPE_ID).ToList()))
            {
                //analyte is in a database and was unselected so need to delete it 
                LAB_ORDER_DETAIL detail = order.LAB_ORDER_DETAILs.Where(lod => lod.STD_ANALYTETYPE_ID == otherValue).Single();

                detail.SetAsDeleteOnSubmit();

            }

        }

        foreach (ListItem item in AnalytesList.Items)
        {

            int value = int.Parse(item.Value);

            if (value > 0)
            {
                if (item.Selected)
                {

                    if (value.In(order.LAB_ORDER_DETAILs.Select(lod => lod.STD_ANALYTETYPE_ID).ToList()))
                    {
                        //do nothing since referral is already in 


                    }
                    else
                    {
                        //need to generate and save a new analyte, as it's not presently in a database 
                        LAB_ORDER_DETAIL detail = new LAB_ORDER_DETAIL();


                        detail.LAB_ORDER_ID = order.LAB_ORDER_ID;
                        detail.STD_ANALYTETYPE_ID = value;

                        order.LAB_ORDER_DETAILs.Add(detail);
                    }
                }
                else
                {
                    if (value.In(order.LAB_ORDER_DETAILs.Select(lod => lod.STD_ANALYTETYPE_ID).ToList()))
                    {
                        //analyte is in a database and was unselected so need to delete it 
                        LAB_ORDER_DETAIL detail = order.LAB_ORDER_DETAILs.Where(lod => lod.STD_ANALYTETYPE_ID == value).Single();

                        detail.SetAsDeleteOnSubmit();

                    }
                    else
                    {
                        //analyte is not in a database so no need to do anything

                    }
                }
            }
        }
    }
    protected override void LoadViewState(object savedState)
    {
        base.LoadViewState(savedState);
        string activityXml = (string)ViewState["activityXml"];
        _activity = SerializerUtil.Deserialize<WKF_CASE_ACTIVITY>(activityXml);

    }

    protected override object SaveViewState()
    {
        ViewState["activityXml"] = _activity.Serialize();
        return base.SaveViewState();

    }


    protected void SaveButton_Click(object sender, EventArgs e)
    {
        if (_activity.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.Voided)
        {
            _activity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.New;

        }

        //if (_activity.STD_WKFACTIVITYSTS_ID != 2)
        //{
        //    _activity.STD_WKFACTIVITYSTS_ID = 1;
        //}

        SaveCompleteLabOrder(() => "Save");
        SetupBioLabOrder();
    }

    protected void CancelButton_Click(object sender, EventArgs e)
    {
        RedirectToReferringPage();
    }

    protected void CompleteButton_Click(object sender, EventArgs e)
    {
        _activity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.AwaitingResults;
        //this un-voids lab result so have to open or re-open workflow(case) if it's not open



        bool labResultExists = _manager.ActivityExists(_activity.WKF_CASE_ID, WorkFlowActivityTypes.LabResult);

        if (!labResultExists)
        {
            //create lab result _activity since it's no longer simulated 
            WKF_CASE_ACTIVITY NewActivity = new WKF_CASE_ACTIVITY();

            NewActivity.WKF_CASE_ID = _activity.WKF_CASE_ID;
            NewActivity.STD_WKFACTIVITYTYPE_ID = Convert.ToInt16(WorkFlowActivityTypes.LabResult);
            NewActivity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(WorkflowCaseActivityStatus.New);
            NewActivity.REPRESENTATIVE_NAME = _activity.REPRESENTATIVE_NAME;
            NewActivity.CONTACT_NAME = "Dr. Brown";

            NewActivity.SetAsChangeTrackingRoot(EntityState.New, true);
            NewActivity.SetAsInsertOnSubmit();
            _manager.Update(NewActivity);
        }

        SaveCompleteLabOrder(() => "Complete");

        SetupBioLabOrder();
    }


    protected void PrintButton_Click(object sender, EventArgs e)
    {
        SuppressSaveSuccessMessage = true;
        //(this.Master as RegistryMaster).SetDirtyFlag(false);
        var master = this.Master as RegistryMaster;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        //Response.Redirect("LabOrderSummary.aspx?activityId={0}", _activity.WKF_CASE_ACTIVITY_ID);
        Response.Redirect("TefscLaboratoryRequestReport.aspx?activityId={0}", _activity.WKF_CASE_ACTIVITY_ID);
    }
    protected void VoidButton_Click(object sender, EventArgs e)
    {

        LabRequestDate.Text = "";
        LabSampleReceivedDate.Text = "";

        _activity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.Voided;


        SaveCompleteLabOrder(() => "Void");

        SetupBioLabOrder();

    }


    private void OpenCloseReferralAndWorkflowCase(Func<string> operation)
    {
        ReferralManager rm = new ReferralManager();
        //WorkflowManager wfm = new WorkflowManager();
        int wfCaseRefId;
        if (int.TryParse(ViewState["ReferralCaseId"].ToString(), out wfCaseRefId))
        {
            EFR_REFERRAL parentReferral = rm.getReferralByReferralID(wfCaseRefId);


            parentReferral = SerializerUtil.Deserialize<EFR_REFERRAL>(parentReferral.Serialize());
            parentReferral.SetAsChangeTrackingRoot();

            WKF_CASE parentCase = parentReferral.WKF_CASEs.Where(a => a.WKF_CASE_ID == _activity.WKF_CASE_ID).First();

            if (operation() == "Void")
            {
                parentCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.Completed;
                var items = parentReferral.WKF_CASEs.Except(new List<WKF_CASE> { parentCase }, new WorkflowCaseManager.WorkflowCaseComparer());

                if (items.Count(a => a.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.Completed) == 0)

                    parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.Completed;
            }
            else
            {
                if (parentReferral.STD_REFERRALSTS_ID != (int)ReferralStatus.InProcess)
                    parentReferral.STD_REFERRALSTS_ID = (int)ReferralStatus.InProcess;


                if (parentCase.STD_WKFCASESTS_ID != (int)WorkFlowCaseStatus.InProcess)
                    parentCase.STD_WKFCASESTS_ID = (int)WorkFlowCaseStatus.InProcess;

            }

            SuppressSaveSuccessMessage = true;
            rm.Update(parentReferral);

            SuppressSaveSuccessMessage = false;
        }
    }



    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "Lab Orders";
    }

    public override string AppObjectCode()
    {

        return "EFR_LABORDER";
    }

    protected void Reopen_LabOrder_Click(object sender, EventArgs e)
    {

        try
        {
            Logging.WriteLogToFile("EFR - Starting Re-Open Lab Order.");

            _activity.STD_WKFACTIVITYSTS_ID = (int)WorkflowCaseActivityStatus.AwaitingResults;
            SaveCompleteLabOrder(() => "ReOpen");

            SetupBioLabOrder();
            Logging.WriteLogToFile("EFR - Complete Re-Open Lab Order.");

        }
        catch (Exception)
        {
            Logging.WriteLogToFile("EFR - Error Re-Opening Lab Order.");
        }

    }
}
